/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.textmc.pipeline;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import icyllis.modernui.graphics.textmc.pipeline.EffectRenderType;
import icyllis.modernui.graphics.textmc.pipeline.GlyphRender;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;

public class TextRenderNode {
    public static final TextRenderNode EMPTY = new TextRenderNode(new GlyphRender[0], 0.0f, false){

        @Override
        public float drawText(@Nonnull BufferBuilder builder, @Nonnull String raw, float x, float y, int r, int g2, int b, int a) {
            return 0.0f;
        }

        @Override
        public float drawText(Matrix4f matrix, IRenderTypeBuffer buffer, @Nonnull CharSequence raw, float x, float y, int r, int g2, int b, int a, boolean isShadow, boolean seeThrough, int colorBackground, int packedLight) {
            return 0.0f;
        }
    };
    public static final int BASELINE_OFFSET = 7;
    public static final int VANILLA_BASELINE_OFFSET = 6;
    public final GlyphRender[] glyphs;
    public final float advance;
    private final boolean hasEffect;

    public TextRenderNode(GlyphRender[] glyphs, float advance, boolean hasEffect) {
        this.glyphs = glyphs;
        this.advance = advance;
        this.hasEffect = hasEffect;
    }

    public float drawText(@Nonnull BufferBuilder builder, @Nonnull String raw, float x, float y, int r, int g2, int b, int a) {
        int color;
        int startR = r;
        int startG = g2;
        int startB = b;
        y += 7.0f;
        x -= 1.0f;
        RenderSystem.enableTexture();
        for (GlyphRender glyph : this.glyphs) {
            if (glyph.color != -2) {
                color = glyph.color;
                if (color == -1) {
                    r = startR;
                    g2 = startG;
                    b = startB;
                } else {
                    r = color >> 16 & 0xFF;
                    g2 = color >> 8 & 0xFF;
                    b = color & 0xFF;
                }
            }
            glyph.drawGlyph(builder, raw, x, y, r, g2, b, a);
        }
        if (this.hasEffect) {
            r = startR;
            g2 = startG;
            b = startB;
            x += 1.0f;
            RenderSystem.disableTexture();
            builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            for (GlyphRender glyph : this.glyphs) {
                if (glyph.color != -2) {
                    color = glyph.color;
                    if (color == -1) {
                        r = startR;
                        g2 = startG;
                        b = startB;
                    } else {
                        r = color >> 16 & 0xFF;
                        g2 = color >> 8 & 0xFF;
                        b = color & 0xFF;
                    }
                }
                glyph.drawEffect((IVertexBuilder)builder, x, y, r, g2, b, a);
            }
            builder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)builder);
        }
        return this.advance;
    }

    public float drawText(Matrix4f matrix, IRenderTypeBuffer buffer, @Nonnull CharSequence raw, float x, float y, int r, int g2, int b, int a, boolean isShadow, boolean seeThrough, int colorBackground, int packedLight) {
        int startR = r;
        int startG = g2;
        int startB = b;
        if (buffer instanceof IRenderTypeBuffer.Impl) {
            ((IRenderTypeBuffer.Impl)buffer).func_228462_a_(Atlases.func_228780_e_());
        }
        y += 6.0f;
        x -= 1.0f;
        for (GlyphRender glyph : this.glyphs) {
            if (glyph.color != -2) {
                int color = glyph.color;
                if (color == -1) {
                    r = startR;
                    g2 = startG;
                    b = startB;
                } else {
                    r = color >> 16 & 0xFF;
                    g2 = color >> 8 & 0xFF;
                    b = color & 0xFF;
                    if (isShadow) {
                        r >>= 2;
                        g2 >>= 2;
                        b >>= 2;
                    }
                }
            }
            glyph.drawGlyph(matrix, buffer, raw, x, y, r, g2, b, a, seeThrough, packedLight);
        }
        IVertexBuilder builder = null;
        x += 1.0f;
        if (this.hasEffect) {
            r = startR;
            g2 = startG;
            b = startB;
            builder = buffer.getBuffer((RenderType)EffectRenderType.getRenderType(seeThrough));
            for (GlyphRender glyph : this.glyphs) {
                if (glyph.color != -2) {
                    int color = glyph.color;
                    if (color == -1) {
                        r = startR;
                        g2 = startG;
                        b = startB;
                    } else {
                        r = color >> 16 & 0xFF;
                        g2 = color >> 8 & 0xFF;
                        b = color & 0xFF;
                        if (isShadow) {
                            r >>= 2;
                            g2 >>= 2;
                            b >>= 2;
                        }
                    }
                }
                glyph.drawEffect(matrix, builder, x, y, r, g2, b, a, packedLight);
            }
        }
        if (colorBackground != 0) {
            y -= 6.0f;
            a = colorBackground >> 24 & 0xFF;
            r = colorBackground >> 16 & 0xFF;
            g2 = colorBackground >> 8 & 0xFF;
            b = colorBackground & 0xFF;
            if (builder == null) {
                builder = buffer.getBuffer((RenderType)EffectRenderType.getRenderType(seeThrough));
            }
            builder.func_227888_a_(matrix, x - 1.0f, y + 9.0f, 0.01f).func_225586_a_(r, g2, b, a).func_227886_a_(packedLight).func_181675_d();
            builder.func_227888_a_(matrix, x + this.advance + 1.0f, y + 9.0f, 0.01f).func_225586_a_(r, g2, b, a).func_227886_a_(packedLight).func_181675_d();
            builder.func_227888_a_(matrix, x + this.advance + 1.0f, y, 0.01f).func_225586_a_(r, g2, b, a).func_227886_a_(packedLight).func_181675_d();
            builder.func_227888_a_(matrix, x - 1.0f, y, 0.01f).func_225586_a_(r, g2, b, a).func_227886_a_(packedLight).func_181675_d();
        }
        return this.advance;
    }
}

